#include "p18f27j53.h"
#include "main.h"
#include "io.h"

/* 

	IO System, by Mauro Grassi, 2010.

*/

#pragma udata iodata

volatile unsigned char ioOpen;

#pragma code usercode

const rom unsigned char RPNNumber[6]={ 7, 8, 9, 10, 0, 1 };

unsigned char openIOObject(unsigned char ch, unsigned char dir)
{
	unsigned char result;
	unsigned char ioch;
	
	result=0;
	if((ch>=0)&&(ch<=5))
	{	
		switch(ch)
		{	
			default:
				ioch=0;
				break;
				
			case 0:
				ioch=IO_CH0;
				TRISBbits.TRISB4=dir;
				result=1;
				break;

			case 1:
				ioch=IO_CH1;
				TRISBbits.TRISB5=dir;
				result=1;
				break;

			case 2:
				ioch=IO_CH2;
				TRISBbits.TRISB6=dir;
				result=1;
				break;

			case 3:
				ioch=IO_CH3;
				TRISBbits.TRISB7=dir;
				result=1;
				break;
			
			case 4:
				ioch=IO_CH4;
				TRISAbits.TRISA0=dir;
				ANCON0bits.PCFG0=1;
				result=1;
				break;
		
			case 5:
				ioch=IO_CH5;
				TRISAbits.TRISA1=dir;
				ANCON0bits.PCFG1=1;
				result=1;
				break;
		}

		if(dir)
		{
			ioOpen|=ioch;
		}
		else
		{
			ioOpen&=~ioch;
		}
	}
	return result;	
}

void closeAllIO(void)
{
	TRISB|=0xF0;
	TRISA|=0x03;
}

void openAllIO(unsigned char x)
{
	unsigned char c;
	unsigned char mask;
	
	mask=IO_CH0;
	for(c=0; c<=5; c++)
	{
		if(x & mask)
		{
			openIOObject(c, 1);
		}
		else
		{
			openIOObject(c, 0);
		}
		mask=mask<<1;
	}
}

unsigned char closeIOObject(unsigned char ch)
{
	/* make an input */
	return openIOObject(ch, 1);
}

unsigned char setIOObject(unsigned char ch, unsigned char val)
{
	unsigned char result;
	
	result=0;
	if((ch>=0)&&(ch<=5))
	{	
		switch(ch)
		{	
			default:
				break;
				
			case 0:
				LATBbits.LATB4=val;
				result=1;
				break;

			case 1:
				LATBbits.LATB5=val;
				result=1;
				break;

			case 2:
				LATBbits.LATB6=val;
				result=1;
				break;

			case 3:
				LATBbits.LATB7=val;
				result=1;
				break;
			
			case 4:
				LATAbits.LATA0=val;
				result=1;
				break;
		
			case 5:
				LATAbits.LATA1=val;
				result=1;
				break;
		}
	}
	return result;	
}

unsigned char getIOObject(unsigned char ch)
{
	unsigned char result;
	
	result=0;
	if((ch>=0)&&(ch<=5))
	{	
		switch(ch)
		{	
			default:
				break;
				
			case 0:
				result=PORTBbits.RB4;
				break;

			case 1:
				result=PORTBbits.RB5;
				break;

			case 2:
				result=PORTBbits.RB6;
				break;

			case 3:
				result=PORTBbits.RB7;
				break;
			
			case 4:
				result=PORTAbits.RA0;
				break;
		
			case 5:
				result=PORTAbits.RA1;
				break;
		}
	}
	return result;	
}

unsigned char getRPNNumber(unsigned char ch)
{
	unsigned char result;
	
	result=0;
	if((ch>=0)&&(ch<=5))
	{
		result=RPNNumber[ch];
	}
	return result;
}

unsigned char setRPNValue(unsigned char ch, unsigned char value)
{
	unsigned char result;
	
	result=0;
	if((ch>=0)&&(ch<=5))
	{	
		switch(ch)
		{	
			default:
				break;
				
			case 0:
				RPOR7=value;
				result=1;
				break;

			case 1:
				RPOR8=value;
				result=1;
				break;

			case 2:
				RPOR9=value;
				result=1;
				break;

			case 3:
				RPOR10=value;
				result=1;
				break;
			
			case 4:
				RPOR0=value;
				result=1;
				break;
		
			case 5:
				RPOR1=value;
				result=1;
				break;
		}
	}
	return result;	
}
